/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validator.CreditCardValidator.java
 * Desprition : This Validator class is responsible for checking and validating the 
 * Customer Credit card Information
 * 
 */
package Validators;

import DataClasses.*;
/**
 * @author student
 *
 * This class is being used for validating credit card details.
 * 
 */
public class CreditCardValidator {

	private String message;

	/**
	 * This method is being used for getting the error message if the 
	 * validation is unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for setting the error message.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validating the given credit card details.
	 * @param creditCardData The credit card details to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(CreditCard_Data creditCardData) {

		CreditCard_Data creditcarddata = creditCardData;
		String cardType, cardHolderName, expiryDate;
		String cardNumber;

		cardType = creditcarddata.getCardType();
		cardHolderName = creditcarddata.getCardHolderName();
		cardNumber = creditcarddata.getCardNumber();
		expiryDate = creditcarddata.getExpiryDate();

		if (cardType == null
			|| cardHolderName == null
			|| expiryDate == null
			|| cardNumber == null) {
			message = "Some of the required credit card details are invalid.";
			return false;
		}
		if (!cardType.matches("^[a-zA-Z/(/)0-9/ ]+$")) {
			message = "You must select a credit card type.";
			return false;
		}
		if (!cardHolderName.matches("^[a-zA-Z/(/)/'/-/0-9///./,/ ]+$")) {
			message = "Holder name has invalid characters.";
			return false;
		}
		if (!expiryDate.matches("^[0-9]{4}+$")) {
			message = "Expiry Date has invalid characters.";
			message += " The month and year should be digits. ";
			return false;
		}
		if (!cardNumber.matches("^[0-9]{10,16}+$")) {
			message = "Card number has invalid characters.";
			message += " Card number should have 10 to 16 digits.";
			message += " Only Digits are allowed.";
			return false;
		}
		return true;
	}

}
